<?php 

/**
 * Template part for displaying header layout four
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
*/

// header right
$bixola_header_right = bixola_get_option( 'bixola_header_right', false );
$bixola_search_switch = bixola_get_option( 'bixola_search_switch', false );
$bixola_header_phone = bixola_get_option( 'bixola_header_phone', false );
$bixola_phone_label = bixola_get_option( 'bixola_phone_label', __( 'Need help?', 'bixola' ) );
$bixola_phone_text = bixola_get_option( 'bixola_phone_text', __( '+1 212 333 400', 'bixola' ) );
$bixola_phone_link = bixola_get_option( 'bixola_phone_link', __( '+1212333400', 'bixola' ) );

// header sticky
$bixola_sticky_hide = bixola_get_option( 'bixola_sticky_hide', false );

?>

<header class="main-header-four">
    <nav class="main-menu main-menu-four">
        <div class="main-menu-four__wrapper">
            <div class="main-menu-four__wrapper-inner">
                <div class="main-menu-four__logo">
                    <?php bixola_header_logo_white(); ?>
                </div>
                <div class="main-menu-four__main-menu-box">
                    <a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
                    <?php bixola_header_menu();?>
                </div>
                <?php if ( !empty( $bixola_header_right ) ): ?>
                    <div class="main-menu-four__right">
                        <?php if ( !empty( $bixola_phone_text ) ): ?>
                            <div class="main-menu-four__call">
                                <div class="main-menu-four__call-icon">
                                    <span class="icon-phone-call"></span>
                                </div>
                                <div class="main-menu-four__call-content">
                                    <p class="main-menu-four__call-sub-title"><?php echo esc_html($bixola_phone_label); ?></p>
                                    <h5 class="main-menu-four__call-number">
                                        <a href="tel:<?php echo esc_attr($bixola_phone_link); ?>">
                                            <?php echo esc_html($bixola_phone_text); ?> 
                                        </a>
                                    </h5>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if ( !empty( $bixola_search_switch ) ): ?>
                            <div class="main-menu-four__search-cart-box">
                                <div class="main-menu-four__search-box">
                                    <a href="<?php print esc_attr( get_search_query() ); ?>" class="main-menu-four__search search-toggler icon-magnifying-glass"></a>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </nav>
</header>

<?php if ( !empty( $bixola_sticky_hide ) ): ?>
    <div class="stricky-header stricked-menu main-menu main-menu-four">
        <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
    </div><!-- /.stricky-header -->
<?php endif;?>

<?php get_template_part( 'template-parts/header/header-side-info' ); ?>